/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain;

import com.dto.LoginDto;
import com.dto.PaymentDto;
import com.instalments.data.InstalmentEntity;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentSettleDto;
import com.instalments.domain.use_case.BatchInsertInstalments;
import com.instalments.domain.use_case.GetInstalments;
import com.instalments.domain.use_case.SettleInstalment;
import com.instalments.domain.use_case.SettleInstalmentNoDoc;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.JsonParser;
import com.utility.Pair;
import com.utility.TextNormalizer;
import com.utility.TncException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InstalmentService {
    private final DbConnection dbConnection;
    @Lazy
    @Resource
    private final GetInstalments getInstalments;
    @Lazy
    @Resource
    private SettleInstalment settleInstalment;
    @Lazy
    @Resource
    private SettleInstalmentNoDoc settleInstalmentNoDoc;
    @Lazy
    @Resource
    private JsonParser jsonParser;
    @Lazy
    @Resource
    private BatchInsertInstalments batchInsertInstalments;

    public ResponseEntity<List<InstalmentDto>> getInstalments(HttpServletRequest request) {
        LoginDto login = SecurityConstants.loadToken();
        List instalments = this.getInstalments.invoke(request);
        if (!login.getIsMyHoloo().booleanValue()) {
            instalments = instalments.stream().peek(dto -> {
                String cCode = ConvertStr.encrypt((String)dto.getCustomerCode());
                dto.setCustomerCode(cCode);
            }).collect(Collectors.toList());
        }
        return ResponseEntity.ok((Object)TextNormalizer.getNormalizedText((List)instalments, InstalmentDto.class));
    }

    public ResponseEntity<Map<String, Object>> settleInstalments(List<InstalmentSettleDto> settleDtoList) {
        ArrayList<Map> failed = new ArrayList<Map>();
        ArrayList<Map> succeeded = new ArrayList<Map>();
        for (InstalmentSettleDto settleDto : settleDtoList) {
            try {
                LoginDto login = SecurityConstants.loadToken();
                SettleInstalment.InstalmentSettleResult docData = (SettleInstalment.InstalmentSettleResult)this.dbConnection.getTransactionTemplate(login).execute(status -> {
                    if (!login.getIsMyHoloo().booleanValue() && settleDto.isWithDoc()) {
                        return this.settleInstalment.invoke(settleDto);
                    }
                    return this.settleInstalmentNoDoc.invoke(settleDto);
                });
                assert (docData != null);
                Map successMap = this.makeSuccesMap(docData);
                successMap.put("index", settleDto.getIndex());
                succeeded.add(successMap);
            }
            catch (TncException e) {
                e.putMoreInfo("index", (Object)settleDto.getIndex());
                failed.add(e.getErrorMap());
            }
            catch (Exception e) {
                failed.add(TncException.fromException((Throwable)e).getErrorMap());
            }
        }
        return ConvertStr.getMapResponseEntity((String)"Instalment", failed, succeeded);
    }

    private Map<String, Object> makeSuccesMap(SettleInstalment.InstalmentSettleResult settleResult) {
        PaymentDto docData = settleResult.getDocData();
        return ConvertStr.buildMap(model -> {
            if (!ConvertStr.isNullOrEmpty((String)docData.getInputid())) {
                model.put("id", docData.getInputid());
            }
            model.put("stableDocCode", docData.getFixsanadcode());
            model.put("docCode", docData.getDocCode());
            if (settleResult.isRemainderAddedToNext()) {
                model.put("comment", "\u0645\u0628\u0644\u063a \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0628\u0627 \u0645\u0628\u0644\u063a \u06a9\u0644 \u0642\u0633\u0637 \u0628\u0631\u0627\u0628\u0631 \u0646\u0628\u0648\u062f \u0648 \u0631\u0648\u06cc \u0645\u0628\u0644\u063a \u06a9\u0644 \u0642\u0633\u0637 \u0628\u0639\u062f\u06cc \u0627\u0639\u0645\u0627\u0644 \u0634\u062f");
            }
        });
    }

    public ResponseEntity<Map<String, Object>> postSmartHelpInstalments(byte[] zippedBody) {
        Pair result = this.batchInsertInstalments.invoke((InstalmentEntity[])this.jsonParser.parseJson(ConvertStr.deCompressionGZip((byte[])zippedBody), InstalmentEntity[].class));
        return ConvertStr.getMapResponseEntity((String)"Instalment", (Boolean)result.getLeft() != false ? Collections.emptyList() : Collections.singletonList(result.getRight()), (Boolean)result.getLeft() != false ? Collections.singletonList(result.getRight()) : Collections.emptyList());
    }

    public InstalmentService(DbConnection dbConnection, GetInstalments getInstalments) {
        this.dbConnection = dbConnection;
        this.getInstalments = getInstalments;
    }
}

